unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure ListBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListBox2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormResize(Sender: TObject);
begin
ListBox1.Width:=ClientWidth div 2;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i :Integer;
begin
for i:=0 to 9 do
    begin
    ListBox1.Items.Add('Lista 1 : '+IntToStr(i));
    ListBox2.Items.Add('Lista 2 : '+IntToStr(i));
    end;
end;


procedure TForm1.ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if (Button=mbLeft) and (ListBox1.ItemIndex>=0) then
  ListBox1.BeginDrag(false);
end;

procedure TForm1.ListBox2DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
Accept:=false;
if (Source=ListBox1) and (ListBox1.ItemIndex>=0) then
  Accept:=true;
end;

procedure TForm1.ListBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
var punkt :TPoint;
begin
punkt.X:=X;
punkt.Y:=Y;
ListBox2.Items.Insert(ListBox2.ItemAtPos(punkt,False),ListBox1.Items.Strings[ListBox1.ItemIndex]);
ListBox1.Items.Delete(ListBox1.ItemIndex);

{
//dodawanie na koncu
ListBox2.Items.Add(ListBox1.Items.Strings[ListBox1.ItemIndex]);
ListBox1.Items.Delete(ListBox1.ItemIndex);
}
end;

end.
